set deadlock_priority 9
BEGIN
    ALTER TABLE EST_NF_ENT_IT DISABLE TRIGGER TRG_EST_NF_ENT_IT_PRIMEIRA_ENTRADA
    ALTER TABLE EST_NF_ENT_IT DISABLE TRIGGER TRG_EST_PROD_CPL_ULT_MOV_GLB_MOV_OP_ENTRADA
    ALTER TABLE EST_NF_ENT_IT DISABLE TRIGGER TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA
    ALTER TABLE EST_NF_ENT_IT DISABLE TRIGGER TRG_EST_NF_ENT_IT_SNGPC_PENDENTE
END
go

/****** Object:  Trigger [TRG_EST_NF_ENT]    Script Date: 01/08/2014 05:08:15 ******/
IF EXISTS(SELECT NAME FROM SYS.TRIGGERS 
			WHERE NAME = 'TRG_EST_NF_ENT')
    BEGIN
        DROP TRIGGER [dbo].[TRG_EST_NF_ENT];
    END;

/****** Object:  Trigger [TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA]    Script Date: 01/08/2014 05:08:15 ******/

IF EXISTS( SELECT NAME FROM SYS.TRIGGERS 
				WHERE NAME = 'TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA')
    BEGIN
        DROP TRIGGER [dbo].[TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA];
    END;
GO

IF NOT EXISTS(SELECT *FROM INFORMATION_SCHEMA.COLUMNS 
				WHERE TABLE_NAME  = 'EST_PROD_CPL_EST_NF_IT_ULTIMA'
						AND COLUMN_NAME ='CD_NF_ICMS_RET')
BEGIN
	ALTER TABLE EST_PROD_CPL_EST_NF_IT_ULTIMA ADD CD_NF_ICMS_RET INT NULL 
END
GO
IF NOT EXISTS(SELECT *FROM INFORMATION_SCHEMA.COLUMNS 
				WHERE TABLE_NAME  = 'EST_PROD_CPL_EST_NF_IT_ULTIMA'
						AND COLUMN_NAME ='PERC_ICMS_RET')
BEGIN
	ALTER TABLE EST_PROD_CPL_EST_NF_IT_ULTIMA ADD PERC_ICMS_RET MONEY NULL  
END
go
IF EXISTS (SELECT 1 FROM SYS.TRIGGERS WHERE NAME ='TRG_EST_NF_ENT_IT_PROCS' AND PARENT_ID=OBJECT_ID('EST_NF_ENT_IT'))
    BEGIN
	   DROP TRIGGER TRG_EST_NF_ENT_IT_PROCS
    END
GO
CREATE TRIGGER TRG_EST_NF_ENT_IT_PROCS ON EST_NF_ENT_IT 
FOR INSERT 
AS 
    CREATE TABLE #ENTRADA
			(
				CD_EMP    INT, 
				CD_FILIAL INT ,
				CD_NF     INT ,
				CD_PROD	INT ,
				CD_NT_MOV INT ,
				DT_ENT    DATETIME
			 )
    
    INSERT INTO #ENTRADA
	   SELECT 
		  I.CD_EMP,
		  I.CD_FILIAL,
		  I.CD_NF,
		  I.CD_PROD,
		  E.CD_NT_MOV,
		  E.DT_ENT
	    FROM 
	    INSERTED I INNER JOIN EST_NF_ENT E ON 
						I.CD_EMP = E.CD_EMP AND 
						I.CD_FILIAL = E.CD_FILIAL AND 
						I.CD_NF = E.CD_NF AND 
						I.DT_ENT = E.DT_ENT
	   WHERE E.CD_EMP = 1 

 ------------------------------------------------------------------------------------------------------------------------ 
 -- TRG_EST_NF_ENT_IT_PRIMEIRA_ENTRADA
 ------------------------------------------------------------------------------------------------------------------------ 

 IF NOT EXISTS (SELECT 
			S.CD_PROD
		FROM         
			EST_PROD_CPL_NASC PROD INNER JOIN #ENTRADA S ON
			PROD.CD_EMP = S.CD_EMP  AND
			PROD.CD_FILIAL = S.CD_FILIAL AND
			PROD.CD_PROD = S.CD_PROD)
	BEGIN
		INSERT INTO
			EST_PROD_CPL_NASC
		SELECT
			CD_EMP,
			CD_FILIAL,
			CD_PROD,
			CONVERT(CHAR(10),GETDATE(),112),
			0,
			0
		FROM
			#ENTRADA S	
	END

 ------------------------------------------------------------------------------------------------------------------------ 
 -- TRG_EST_PROD_CPL_ULT_MOV_GLB_MOV_OP_ENTRADA
 ------------------------------------------------------------------------------------------------------------------------ 
 
 	IF EXISTS ( SELECT CD_EMP   
					FROM INSERTED   
					WHERE QT_IT <> 0)  
    BEGIN

	--deletando registro caso exista  
	DELETE  m  
	FROM    
		EST_PROD_CPL_ULT_MOV_GLB_MOV_OP m 
		INNER JOIN #ENTRADA i ON  
		m.CD_EMP	= i.CD_EMP AND  
		m.CD_FILIAL = i.CD_FILIAL AND  
		m.CD_MOV_OP = CD_NT_MOV AND  
		m.CD_PROD	= i.CD_PROD  

	--Inserindo novo registro  
	INSERT INTO EST_PROD_CPL_ULT_MOV_GLB_MOV_OP  (   CD_EMP,   	CD_FILIAL,   	CD_PROD,   
													CD_MOV_OP,   	DT_MOV  	)  
	SELECT  
		CD_EMP,  
		CD_FILIAL,  
		CD_PROD,  
		CD_NT_MOV,  
		DT_ENT  
	FROM  
		#ENTRADA 
    END 

 ------------------------------------------------------------------------------------------------------------------------ 
 -- TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA
 ------------------------------------------------------------------------------------------------------------------------
 
------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE #TMP_NFUltima (CD_EMP		INT, 
							CD_FILIAL	INT,	
							CD_PROD		INT, 							
							CD_NF		INT, 
							CD_NF_ICMS_RET	INT null, 
							PERC_ICMS_RET money null)
	
	insert into #TMP_NFUltima(	CD_EMP, CD_FILIAL, CD_PROD,	CD_NF,	CD_NF_ICMS_RET, PERC_ICMS_RET )
	SELECT
		INS.CD_EMP,
		INS.CD_FILIAL,
		INS.CD_PROD,
		INS.CD_NF,
		INS.CD_NF,		
		INS.PERC_ICMS_RET
    FROM 
		INSERTED INS
        INNER JOIN EST_NF_ENT ON INS.CD_EMP = EST_NF_ENT.CD_EMP
                                AND INS.CD_FILIAL = EST_NF_ENT.CD_FILIAL
                                AND INS.CD_NF = EST_NF_ENT.CD_NF
        INNER JOIN GLB_MOV_OP ON EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP;

------------------------------------------------------------------------------------------------------------------------------
	
	update #TMP_NFUltima set CD_NF_ICMS_RET = null, PERC_ICMS_RET= NULL
		WHERE 
			NOT PERC_ICMS_RET >0 ;

------------------------------------------------------------------------------------------------------------------------------
	--Preserva o codigo do icms_ret da ultima nota fiscal.
	
	update t 
	set
		CD_NF_ICMS_RET = U.CD_NF_ICMS_RET, 
		PERC_ICMS_RET  = U.PERC_ICMS_RET
	from 
		#TMP_NFUltima t
		join EST_PROD_CPL_EST_NF_IT_ULTIMA u on 
		t.CD_EMP	= u.CD_EMP AND 
		t.CD_FILIAL = u.CD_FILIAL AND 
		t.CD_NF		= u.CD_NF AND 
		t.CD_PROD	= u.CD_PROD
	WHERE
		T.CD_NF_ICMS_RET IS NULL

------------------------------------------------------------------------------------------------------------------------------

	--Removendo se caso existir o registro.
	DELETE FROM u
	FROM 
		#TMP_NFUltima t
		join EST_PROD_CPL_EST_NF_IT_ULTIMA u on 
		t.CD_EMP	= u.CD_EMP AND 
		t.CD_FILIAL = u.CD_FILIAL AND 
		t.CD_PROD	= u.CD_PROD;
		 
------------------------------------------------------------------------------------------------------------------------------
	--Inserindo se caso for entrada por compras de mercadorias
	INSERT INTO EST_PROD_CPL_EST_NF_IT_ULTIMA (CD_EMP
												,CD_FILIAL
												,CD_PROD
												,CD_NF
												,CD_NF_ICMS_RET
												,PERC_ICMS_RET)
	SELECT
		cd_emp
		, cd_filial
		, cd_prod
		, cd_nf
		, cd_nf_icms_ret     
		, perc_icms_ret 
	FROM
		#TMP_NFUltima;


 ------------------------------------------------------------------------------------------------------------------------ 
 -- TRG_EST_NF_ENT_IT_SNGPC_PENDENTE
 ------------------------------------------------------------------------------------------------------------------------

	IF NOT EXISTS (SELECT 
						* 
				    FROM 
						EST_NF_ENT_IT_EST_SNGPC_PENDENTE e INNER JOIN #ENTRADA i ON
						e.CD_EMP    = i.CD_EMP AND
						e.CD_FILIAL = i.CD_FILIAL AND
						e.CD_NF     = i.CD_NF AND
						e.CD_PROD   = i.CD_PROD)	
	Begin
		--Pedencia de lancamento SNGPC
		INSERT INTO EST_NF_ENT_IT_EST_SNGPC_PENDENTE
			SELECT 
				i.CD_EMP, 
				i.CD_FILIAL,
				i.CD_NF,
				i.CD_PROD,
				GETDATE()
			FROM 
				#ENTRADA i INNER JOIN EST_PROD p ON
				i.CD_PROD = p.CD_PROD AND
				i.CD_EMP = p.CD_EMP
				
			WHERE
				p.CONTROLE_SNGPC = 1 OR
				p.FLAG_PRODUTO_CONTROLADO = 1 OR
				P.ANTIBIOTICO=1
    END